
#This script helps to reproduce the results of the analysis of the 
#pipeline accidents study in Section 8 of the main paper.

################################################################
##Analysis of the pipeline accidents study 
################################################################

# Run the following line to make sure that you have a clean R environment
rm(list=ls())


#To get the results you need to call the following packages
library(dplyr);library(lvplot); library(ggplot2); library(readxl); library(copula); library(fitdistrplus); library(nleqslv)
library("survival"); library("survminer")


## Import required source code and read the pipeline accidents dataset.
data=read.csv("D:\\Dashboard\\Article5\\Article Folder\\Dataset\\Data.csv", stringsAsFactors = T)
data_clean=read.csv("D:\\Dashboard\\Article5\\Article Folder\\Dataset\\Data_clean.csv", stringsAsFactors = T)
source("D:\\Dashboard\\Article5\\Article Folder\\CODE\\Example\\EX R Source.R")


## LV plot in Figure 3 
LV(data,'TBE')
LV(data,'cost')

##Cox Proportional Hazards Analysis
cox(data_clean)
## GOF exponential of TBE and Costs and estimate parameter order by rate and p.value
EXP.test(data_clean, d="TBE")
EXP.test(data_clean, d="Costs")
##MLE estimator of HPP ordered by: (gamma,theta_y,tau,AIC)
MLE_HPP(data_clean,copula='clayton')
MLE_HPP(data_clean,copula='frank')
MLE_HPP(data_clean,copula='gumbel')

##MLE estimator of HPP with covariate ordered by: 
##(gamma,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,theta_y,tau,AIC)
MLE_HPPcov(data_clean,copula='clayton')
MLE_HPPcov(data_clean,copula='frank')
MLE_HPPcov(data_clean,copula='gumbel')


## MLE estimator of NHPP (power low) for three model of copulas Order by:
#(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,theta_y_hat,tau,AIC)
IFM_power(data_clean,copula='clayton')
IFM_power(data_clean,copula='frank')
IFM_power(data_clean,copula='gumbel')

## MLE estimator of NHPP (log linear) for three model of copulas Order by:
#(gamma_hat,eta_hat,beta1_hat,beta2_hat,beta3_hat,beta4_hat,beta5_hat,theta_y_hat,tau,AIC)
IFM_Log(data_clean,copula='clayton')
IFM_Log(data_clean,copula='frank')
IFM_Log(data_clean,copula='gumbel')

## Plots of time between failures ,cost  and cost per time unit 
## d=X for  time between failures
##d=Y for cost
##d=W for cost per time unit 
PhaseI(data_clean,d="W")
PhaseI(data_clean,d="logW")
PhaseI(data_clean,d="Y")
PhaseI(data_clean,d="X")
## plot control chart for Phase II d=Org for orignal control limits
## d=Log for log of control limits
PhaseII(data_clean,d="Org")
PhaseII(data_clean,d="Log")

####ARL for power law
ARL_power(1,1.50,-2,1,0.3,1,1,1) # ARL0

####ARL for log linear
ARL_log(1,-2,-2,1,0.3,1,1,1) # ARL0

